#pragma once

#include "BaseApp.h"
#include "BaseWindow.h"
#include "BaseView.h"

class TreeList;

class TView : public BaseView
{
	public:
		TView( BRect f);
		TreeList* GetTree() { return tree; }
	
	private:
		BMessage* message;
		TreeList* tree;
};

class TreeWindow : public BaseWindow
{
	public:
		TreeWindow() : tv(0) {}
	
	protected:	
		virtual BaseView* CreateView(BRect r);
		virtual const char* MenuTemplate();
		void MenuCommand( BMessage& message);
		void MessageReceived( BMessage* m);
		
	private:
		TreeList* tv;
};


class TreeApp : public BaseApp
{
	public:
		TreeApp() : BaseApp('Empt') {}

		virtual	BaseWindow* CreateWindow() { return new TreeWindow; }
};

